/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.IVWScenarioTime;
import filenet.sim.api.VWScenarioTimeType;
import filenet.sim.api.VWScenarioValidationError;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.IFieldCollection;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public final class VWScenarioTimeOffset
implements IVWScenarioTime,
Serializable,
Cloneable {
    private String m_offset = null;
    private int m_units;
    private int m_time = 0;
    private Date m_absoluteBaseTime = null;
    private int m_calculatedDuration = 0;
    private boolean m_isValid = false;

    public VWScenarioTimeOffset(String offset, int units, int time) throws VWException {
        this.setOffset(offset);
        this.setUnits(units);
        this.setTime(time);
    }

    public String getOffset() {
        return this.m_offset;
    }

    public void setOffset(String offset) throws VWException {
        this.m_offset = offset;
    }

    public int getUnits() {
        return this.m_units;
    }

    public void setUnits(int units) {
        this.m_units = units;
    }

    public int getTime() {
        return this.m_time;
    }

    public void setTime(int time) {
        this.m_time = time;
    }

    public void validate(Date absoluteBaseTime, int validationType, String objectName, String workflowName, String mapName, Integer stepId, IFieldCollection mainFields, IFieldCollection inheritedFields, Vector EDefVector) throws VWException {
        VWCompiledExpr compRes;
        this.m_absoluteBaseTime = absoluteBaseTime;
        String expression = this.getOffset();
        String[] theErrorStrings = VWExpr.compileVWExpr(expression, mainFields, inheritedFields, null, null, mainFields != null, compRes = new VWCompiledExpr());
        if (theErrorStrings != null) {
            this.m_isValid = false;
            int errorCount = theErrorStrings.length;
            for (int j = 0; j < errorCount; ++j) {
                VWString theMessage = new VWString("sim.api.VWScenarioTimeType.TimeExpressionSyntaxError", "Syntax error in time expression: {0}", theErrorStrings[j]);
                VWScenarioValidationError theError = new VWScenarioValidationError(validationType, 1, objectName, expression, theMessage.toString(), workflowName, mapName, stepId != null ? stepId : -1);
                EDefVector.addElement(theError);
            }
        } else if (compRes.getResultIsArray() || compRes.getResultType() != 1 && compRes.getResultType() != 8) {
            this.m_isValid = false;
            VWString theMessage = new VWString("sim.api.VWScenarioTimeType.TimeExpressionWrongType", "Invalid time expression. Time expression should evalute to type {0}.", VWFieldType.getLocalizedString(1));
            VWScenarioValidationError theError = new VWScenarioValidationError(validationType, 1, objectName, expression, theMessage.toString(), workflowName, mapName, stepId != null ? stepId : -1);
            EDefVector.addElement(theError);
        } else if (this.m_absoluteBaseTime != null) {
            this.m_calculatedDuration = (Integer)compRes.execute(mainFields, inheritedFields, null);
            this.m_isValid = true;
        }
    }

    public Date getAbsoluteTime() throws VWException {
        if (!this.m_isValid || this.m_absoluteBaseTime == null) {
            return null;
        }
        GregorianCalendar time = new GregorianCalendar();
        time.setTime(this.m_absoluteBaseTime);
        VWScenarioTimeType.addUnitsToTime(time, this.getUnits(), this.m_calculatedDuration);
        int timeInSeconds = this.getTime();
        int hours = timeInSeconds / 3600;
        hours = hours > 0 ? (hours > 12 ? hours - 12 : hours) : 12;
        time.set(10, hours);
        time.set(12, timeInSeconds % 3600 / 60);
        time.set(13, timeInSeconds % 3600 % 60);
        if (timeInSeconds / 3600 < 12) {
            time.set(9, 0);
        }
        time.set(9, 1);
        return time.getTime();
    }

    protected Object clone() {
        VWScenarioTimeOffset clone = null;
        try {
            clone = (VWScenarioTimeOffset)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }
}

